/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.core.useragent;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.core.useragent.MessageInterceptor;
import net.sourceforge.peers.sip.core.useragent.RequestManager;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.core.useragent.handlers.ByeHandler;
import net.sourceforge.peers.sip.core.useragent.handlers.CancelHandler;
import net.sourceforge.peers.sip.core.useragent.handlers.InviteHandler;
import net.sourceforge.peers.sip.core.useragent.handlers.OptionsHandler;
import net.sourceforge.peers.sip.core.useragent.handlers.RegisterHandler;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.syntaxencoding.SipURI;
import net.sourceforge.peers.sip.transaction.ClientTransaction;
import net.sourceforge.peers.sip.transaction.ClientTransactionUser;
import net.sourceforge.peers.sip.transaction.ServerTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransactionUser;
import net.sourceforge.peers.sip.transaction.Transaction;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transactionuser.Dialog;
import net.sourceforge.peers.sip.transactionuser.DialogManager;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class MidDialogRequestManager
extends RequestManager
implements ClientTransactionUser,
ServerTransactionUser {
    public MidDialogRequestManager(UserAgent userAgent, InviteHandler inviteHandler, CancelHandler cancelHandler, ByeHandler byeHandler, OptionsHandler optionsHandler, RegisterHandler registerHandler, DialogManager dialogManager, TransactionManager transactionManager, TransportManager transportManager, Logger logger) {
        super(userAgent, inviteHandler, cancelHandler, byeHandler, optionsHandler, registerHandler, dialogManager, transactionManager, transportManager, logger);
    }

    public void generateMidDialogRequest(Dialog dialog, String method, MessageInterceptor messageInterceptor) {
        SipRequest sipRequest = dialog.buildSubsequentRequest("BYE");
        if ("BYE".equals(method)) {
            this.byeHandler.preprocessBye(sipRequest, dialog);
        }
        if (!"INVITE".equals(method)) {
            ClientTransaction clientTransaction = this.createNonInviteClientTransaction(sipRequest, null, this.byeHandler);
            if (messageInterceptor != null) {
                messageInterceptor.postProcess(sipRequest);
            }
            if (clientTransaction != null) {
                clientTransaction.start();
            }
        }
    }

    public ClientTransaction createNonInviteClientTransaction(SipRequest sipRequest, String branchId, ClientTransactionUser clientTransactionUser) {
        InetAddress inetAddress;
        SipURI sipUri;
        int port;
        String reqUriTransport;
        SipURI destinationUri = RequestManager.getDestinationUri(sipRequest, this.logger);
        String transport = "UDP";
        Hashtable<String, String> params = destinationUri.getUriParameters();
        if (params != null && (reqUriTransport = params.get("transport")) != null) {
            transport = reqUriTransport;
        }
        if ((port = destinationUri.getPort()) == -1) {
            port = 5060;
        }
        if ((sipUri = this.userAgent.getConfig().getOutboundProxy()) == null) {
            sipUri = destinationUri;
        }
        try {
            inetAddress = InetAddress.getByName(sipUri.getHost());
        }
        catch (UnknownHostException e) {
            this.logger.error("unknown host: " + sipUri.getHost(), e);
            return null;
        }
        ClientTransaction clientTransaction = this.transactionManager.createClientTransaction(sipRequest, inetAddress, port, transport, branchId, clientTransactionUser);
        return clientTransaction;
    }

    public void manageMidDialogRequest(SipRequest sipRequest, Dialog dialog) {
        SipHeaders sipHeaders = sipRequest.getSipHeaders();
        SipHeaderFieldValue cseq = sipHeaders.get(new SipHeaderFieldName("CSeq"));
        String cseqStr = cseq.getValue();
        int pos = cseqStr.indexOf(32);
        if (pos < 0) {
            pos = cseqStr.indexOf(9);
        }
        int newCseq = Integer.parseInt(cseqStr.substring(0, pos));
        int oldCseq = dialog.getRemoteCSeq();
        if (oldCseq == -1) {
            dialog.setRemoteCSeq(newCseq);
        } else if (newCseq < oldCseq) {
            SipResponse sipResponse = MidDialogRequestManager.generateResponse(sipRequest, dialog, 500, "Server Internal Error");
            ServerTransaction serverTransaction = this.transactionManager.createServerTransaction(sipResponse, this.userAgent.getSipPort(), "UDP", this, sipRequest);
            serverTransaction.start();
            serverTransaction.receivedRequest(sipRequest);
            serverTransaction.sendReponse(sipResponse);
        } else {
            dialog.setRemoteCSeq(newCseq);
        }
        String method = sipRequest.getMethod();
        if ("BYE".equals(method)) {
            this.byeHandler.handleBye(sipRequest, dialog);
        } else if ("INVITE".equals(method)) {
            this.inviteHandler.handleReInvite(sipRequest, dialog);
        } else if ("ACK".equals(method)) {
            this.inviteHandler.handleAck(sipRequest, dialog);
        } else if ("OPTIONS".equals(method)) {
            this.optionsHandler.handleOptions(sipRequest);
        }
    }

    @Override
    public void transactionFailure() {
    }

    @Override
    public void transactionTimeout(ClientTransaction clientTransaction) {
    }

    @Override
    public void provResponseReceived(SipResponse sipResponse, Transaction transaction) {
    }

    @Override
    public void errResponseReceived(SipResponse sipResponse) {
    }

    @Override
    public void successResponseReceived(SipResponse sipResponse, Transaction transaction) {
    }

    @Override
    public void transactionTransportError() {
    }
}

